float Timer : register(c0);
float OffsetScale : register(c1);
//float xmod : register(c2);
//float ymod : register(c3);
float4 xymod : register(c2);
float4 offmod : register(c3);
float offmult : register(c4);

sampler MainTex : register(s0);
sampler NoiseTex : register(s1);
sampler SinTable : register(s2);

float4 main(float2 texCoord: TEXCOORD0) : COLOR 
{	
   	// Read and scale the distortion offsets
   	float4 _xy = float4(0.5 - texCoord.x, 0.5 - texCoord.y, 0, 0);
   	_xy *= _xy;
	float xy = (_xy.x + _xy.y)*5;
	
	// for reference: the value used as the 2nd param of the fmod function is amt/2 and the value as the divisor is amt*2
	//float amt = 1.5;
	float angle = fmod((xy + Timer), 0.75) / 3;
	float sintimer = tex1D(SinTable, angle).r;

	xymod *= sintimer * float4(texCoord.xy, 0, 0);
   	float2 offset = tex2D(NoiseTex, xymod.xy);
   	offset = ((offset * offmod.x) - offmod.y) * OffsetScale;   	
   	
   	return tex2D(MainTex, texCoord + offset);   	   	
}

technique Default
{
	pass P0
	{
		PixelShader = compile ps_2_0 main();
	}
}
